// KonfiguracjaInterfejsowSieciowychDlg.cpp : implementation file
//

#include "stdafx.h"
#include "KonfiguracjaInterfejsowSieciowych.h"
#include "KonfiguracjaInterfejsowSieciowychDlg.h"
#include "Iphlpapi.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CKonfiguracjaInterfejsowSieciowychDlg dialog




CKonfiguracjaInterfejsowSieciowychDlg::CKonfiguracjaInterfejsowSieciowychDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKonfiguracjaInterfejsowSieciowychDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CKonfiguracjaInterfejsowSieciowychDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
}

BEGIN_MESSAGE_MAP(CKonfiguracjaInterfejsowSieciowychDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CKonfiguracjaInterfejsowSieciowychDlg message handlers

BOOL CKonfiguracjaInterfejsowSieciowychDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	IP_ADAPTER_INFO * pIpInfo = NULL;
	unsigned long rozmiar;
	CString opis;
	wchar_t addr[16] = {'\0'};
	wchar_t nazwaAdaptera[256] = {'\0'};

	if(GetAdaptersInfo(pIpInfo,&rozmiar) == ERROR_BUFFER_OVERFLOW)
	{
		pIpInfo = (IP_ADAPTER_INFO *)malloc(rozmiar);
		if(pIpInfo == NULL) return TRUE;
		if(GetAdaptersInfo(pIpInfo,&rozmiar) == NO_ERROR)
		{
			while(pIpInfo)
			{
				opis.Append(L"++++++++++++++++++++++++++++++\r\n");
				memset(addr,0,16*sizeof(wchar_t));
				mbstowcs(nazwaAdaptera,pIpInfo->AdapterName,256);
				opis.AppendFormat(L"Nazwa Adaptera: %s\r\n",nazwaAdaptera);
				opis.Append(L"Adres MAC: ");
				for (int i = 0; i < pIpInfo->AddressLength; i++)
				{
					if (i == (pIpInfo->AddressLength - 1))
						opis.AppendFormat(L"%.2X", (int) pIpInfo->Address[i]);
				    else
						opis.AppendFormat(L"%.2X-", (int) pIpInfo->Address[i]);
				}
				opis.Append(L"\r\n");
				memset(addr,0,16*sizeof(wchar_t));
				mbstowcs(addr,pIpInfo->IpAddressList.IpAddress.String,16);
				opis.AppendFormat(L"Adres IP: %s\r\n",addr);
				memset(addr,0,16*sizeof(wchar_t));
				mbstowcs(addr,pIpInfo->IpAddressList.IpMask.String,16);
				opis.AppendFormat(L"Maska: %s\r\n",addr);
				memset(addr,0,16*sizeof(wchar_t));
				mbstowcs(addr,pIpInfo->GatewayList.IpAddress.String,16);
				opis.AppendFormat(L"Brama: %s\r\n",addr);
				if(pIpInfo->DhcpEnabled)
				{
					opis.Append(L"DHCP: TAK\r\n");
					memset(addr,0,16*sizeof(wchar_t));
					mbstowcs(addr,pIpInfo->DhcpServer.IpAddress.String,16);
					opis.AppendFormat(L"Adres DHCP: %s\r\n",addr);
				}
				else
					opis.Append(L"DHCP: NIE\r\n");

				opis.Append(L"\r\n\r\n");
				edit1.SetWindowTextW(opis);
				pIpInfo = pIpInfo->Next;
			}
			
		}
		free(pIpInfo);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CKonfiguracjaInterfejsowSieciowychDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CKonfiguracjaInterfejsowSieciowychDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

